var w=Object.defineProperty;var p=(S,t,e)=>t in S?w(S,t,{enumerable:!0,configurable:!0,writable:!0,value:e}):S[t]=e;var d=(S,t,e)=>p(S,typeof t!="symbol"?t+"":t,e);import{J as i,z as y}from"./dark-mode-DfOwWnFq.js";class _{constructor(t=7*24*60*60*1e3){d(this,"db",null);d(this,"DB_NAME","KagiTranslateCache");d(this,"DB_VERSION",2);d(this,"STORE_NAME","translations");d(this,"TTL_MS");d(this,"MAX_CACHE_SIZE",50*1024*1024);d(this,"CLEANUP_THRESHOLD",.9);this.TTL_MS=t,this.init()}async init(){return new Promise((t,e)=>{const a=indexedDB.open(this.DB_NAME,this.DB_VERSION);a.onerror=()=>{i.error("cache","Failed to open database:",a.error),e(a.error)},a.onsuccess=()=>{this.db=a.result,i.info("cache","Database initialized"),this.scheduleCleanup(),t()},a.onupgradeneeded=r=>{const s=r.target.result;if(!s.objectStoreNames.contains(this.STORE_NAME)){const n=s.createObjectStore(this.STORE_NAME,{keyPath:"id"});n.createIndex("timestamp","timestamp",{unique:!1}),n.createIndex("url","url",{unique:!1}),n.createIndex("sourceTarget",["sourceLanguage","targetLanguage"],{unique:!1}),i.debug("cache","Translations store created with indexes")}if(!s.objectStoreNames.contains("alternatives")){const n=s.createObjectStore("alternatives",{keyPath:"id"});n.createIndex("timestamp","timestamp",{unique:!1}),n.createIndex("url","url",{unique:!1}),i.debug("cache","Alternatives store created with indexes")}}})}generateCacheKey(t,e,a,r={}){const s=Object.keys(r).sort().reduce((o,l)=>{const u=r[l];return u!=null&&(o[l]=u),o},{}),h=[t,e,a,JSON.stringify(s)].join("|||"),c=this.simpleHash(h);return i.debug("cache","Generated key:",{hash:c,text:t.substring(0,30),source:e,target:a,params:s}),c}simpleHash(t){let e=0;for(let a=0;a<t.length;a++){const r=t.charCodeAt(a);e=(e<<5)-e+r,e=e&e}return Math.abs(e).toString(36)}calculateSize(t){const e=JSON.stringify(t);return new Blob([e]).size}async set(t,e,a,r,s={},n){if(this.db||await this.init(),!this.db)throw new Error("Database not initialized");const h=this.generateCacheKey(t,a,r,s),c={id:h,text:t,translatedText:e,sourceLanguage:a,targetLanguage:r,timestamp:Date.now(),parameters:s,url:n,size:0};return c.size=this.calculateSize(c),await this.ensureCacheSpace(c.size),new Promise((o,l)=>{const E=this.db.transaction([this.STORE_NAME],"readwrite").objectStore(this.STORE_NAME).put(c);E.onsuccess=()=>{i.info("cache","SAVED:",{id:h,text:t.substring(0,50),translation:e.substring(0,50),params:s}),o()},E.onerror=()=>{i.error("cache","Failed to cache translation:",E.error),l(E.error)}})}async get(t,e,a,r={}){if(this.db||await this.init(),!this.db)return null;const s=this.generateCacheKey(t,e,a,r);return new Promise(n=>{const o=this.db.transaction([this.STORE_NAME],"readonly").objectStore(this.STORE_NAME).get(s);o.onsuccess=()=>{const l=o.result;if(!l){i.debug("cache","MISS - No entry found",{id:s}),n(null);return}const u=Date.now()-l.timestamp;if(u>this.TTL_MS){const g=Math.floor(u/36e5);i.debug("cache","EXPIRED",{id:s,ageInHours:g,ttlInHours:Math.floor(this.TTL_MS/(1e3*60*60))}),this.delete(s),n(null);return}i.info("cache","HIT!",{id:s,text:l.text.substring(0,50),translation:l.translatedText.substring(0,50)}),n(l.translatedText)},o.onerror=()=>{i.error("cache","Failed to get translation:",o.error),n(null)}})}async getBatch(t){if(this.db||await this.init(),!this.db)return new Map;const e=new Map,a=t.map(async r=>{const s=this.generateCacheKey(r.text,r.sourceLanguage,r.targetLanguage,r.parameters||{}),n=await this.get(r.text,r.sourceLanguage,r.targetLanguage,r.parameters||{});e.set(s,n)});return await Promise.all(a),e}async delete(t){if(this.db)return new Promise((e,a)=>{const n=this.db.transaction([this.STORE_NAME],"readwrite").objectStore(this.STORE_NAME).delete(t);n.onsuccess=()=>e(),n.onerror=()=>a(n.error)})}async getStats(){return this.db||await this.init(),this.db?new Promise((t,e)=>{const s=this.db.transaction([this.STORE_NAME],"readonly").objectStore(this.STORE_NAME).getAll();s.onsuccess=()=>{const n=s.result;let h=0,c=Date.now();n.forEach(o=>{h+=o.size,o.timestamp<c&&(c=o.timestamp)}),t({totalSize:h,entryCount:n.length,oldestEntry:c})},s.onerror=()=>e(s.error)}):{totalSize:0,entryCount:0,oldestEntry:Date.now()}}async ensureCacheSpace(t){(await this.getStats()).totalSize+t>this.MAX_CACHE_SIZE*this.CLEANUP_THRESHOLD&&(i.info("cache","Cache approaching limit, cleaning up..."),await this.cleanup())}async cleanup(){if(this.db||await this.init(),!this.db)return 0;const t=Date.now();return new Promise((e,a)=>{const h=this.db.transaction([this.STORE_NAME],"readwrite").objectStore(this.STORE_NAME).index("timestamp").openCursor();let c=0;const o=[];h.onsuccess=l=>{const u=l.target.result;if(u){const g=u.value;t-g.timestamp>this.TTL_MS||c>this.MAX_CACHE_SIZE*.7?o.push(g.id):c+=g.size,u.continue()}else{const g=o.map(E=>this.delete(E));Promise.all(g).then(()=>{i.info("cache",`Cleanup completed, deleted ${o.length} entries`),e(o.length)})}},h.onerror=()=>a(h.error)})}async clear(){if(this.db||await this.init(),!!this.db)return new Promise((t,e)=>{const s=this.db.transaction([this.STORE_NAME],"readwrite").objectStore(this.STORE_NAME).clear();s.onsuccess=()=>{i.info("cache","Cache cleared"),t()},s.onerror=()=>e(s.error)})}async clearByUrl(t){if(this.db||await this.init(),!!this.db)return new Promise((e,a)=>{const s=this.db.transaction([this.STORE_NAME],"readwrite").objectStore(this.STORE_NAME),h=s.index("url").openCursor(IDBKeyRange.only(t));h.onsuccess=c=>{const o=c.target.result;o?(s.delete(o.primaryKey),o.continue()):e()},h.onerror=()=>a(h.error)})}scheduleCleanup(){setInterval(()=>{this.cleanup().catch(t=>{i.error("cache","Scheduled cleanup failed:",t)})},60*60*1e3)}close(){this.db&&(this.db.close(),this.db=null)}}const b=new _,f={enabled:!0,ttlDays:7,maxSizeMB:50,autoCleanup:!0};class m{constructor(){d(this,"settings",f);this.loadSettings()}async loadSettings(){try{const t=await y.storage.local.get("kagi_translate_cache_settings");t.kagi_translate_cache_settings&&(this.settings={...f,...t.kagi_translate_cache_settings})}catch(t){i.error("cache","Failed to load settings:",t)}}async saveSettings(t){this.settings={...this.settings,...t};try{if(await y.storage.local.set({kagi_translate_cache_settings:this.settings}),i.info("cache","Settings saved:",this.settings),t.ttlDays!==void 0){const e=t.ttlDays*24*60*60*1e3;await this.cleanup()}}catch(e){throw i.error("cache","Failed to save settings:",e),e}}getSettings(){return{...this.settings}}isEnabled(){return this.settings.enabled}async clearCache(){try{await b.clear(),i.info("cache","Cache cleared")}catch(t){throw i.error("cache","Failed to clear cache:",t),t}}async clearCacheForUrl(t){try{await b.clearByUrl(t),i.info("cache","Cache cleared for URL:",t)}catch(e){throw i.error("cache","Failed to clear cache for URL:",e),e}}async getStats(){try{const t=await b.getStats();return{...t,totalSizeMB:(t.totalSize/(1024*1024)).toFixed(2),ageInDays:Math.floor((Date.now()-t.oldestEntry)/(24*60*60*1e3))}}catch(t){return i.error("cache","Failed to get stats:",t),{totalSize:0,totalSizeMB:"0",entryCount:0,oldestEntry:Date.now(),ageInDays:0}}}async cleanup(){try{const t=await b.cleanup();return i.info("cache",`Cleanup completed, deleted ${t} entries`),t}catch(t){return i.error("cache","Cleanup failed:",t),0}}async exportCache(){const t=await this.getStats();return JSON.stringify({settings:this.settings,stats:t,exportDate:new Date().toISOString()},null,2)}}const T=new m;export{T as cacheManager};
